// All menu related stuff in here:

var OptionFile = OpenFile('../options.ini');

function RestartMenu()
{
	var menu = new Menu(SW/2-80,SH/2-60,160);
	menu.onCancel = function() { SetFrameRate(0); }
	menu.appendChoice("Restart Level", RestartLevel, White, Blue);
	menu.appendChoice("Exit to Main", function(){ChangeMusic(TitleMusic); GameMenu()}, White, Blue);
	menu.appendChoice("Exit Game", Exit, White, Blue);
	menu.cancelable = false;
	menu.draw();
}

function InGameMenu()
{
	var menu = new Menu(SW/2-90,SH/2-60,180);
	menu.onCancel = function() { SetFrameRate(0); }
	menu.appendChoice("Restart Level", RestartLevel, White, Blue);
	menu.appendChoice("Save Current", SaveCurrent, White, Blue);
	menu.appendChoice("Exit to Main", function(){ChangeMusic(TitleMusic); GameMenu()}, White, Blue);
	menu.appendChoice("Exit Game", Exit, White, Blue);
	menu.appendChoice("Cancel", function(){SetFrameRate(0)}, White, Blue);
	menu.draw();
}

function RestartLevel()
{
	var Name = Player.name;
	SetPersonIgnoreList(Name, []);
	SetPersonSpeed(Name, 2);
	Ferries = [];
	Player.health = 20;
	Player.healthv = 20;
	Player.death = false;
	Player.dieing = false;
	Player.jumping = false;
	Player.dead = false;
	SetPersonDirection(Name, "north")
	SetPersonScript(Name, SCRIPT_COMMAND_GENERATOR, '');
	TileMovement.attachInput(Name);
	ChangeMap(GetCurrentMap());
	SetFrameRate(0);
}

function SaveCurrent()
{
	DrawTitle();
	font.drawText(SW/2-80,SH/2-35,"SAVE A GAME");
	window.drawWindow(SW/2-80,SH/2-10,160,20);
	var name = GetString(SW/2-78,SH/2-10,font,10);
	var file = OpenFile(name+".sav");
	file.write("ghghghg", Level);
	with(Audio) file.write("ghjggh", CurrentSound);
	file.flush();
	file.close();
}

function SaveNext()
{
	DrawTitle();
	font.drawText(SW/2-80,SH/2-35,"SAVE A GAME");
	window.drawWindow(SW/2-80,SH/2-10,160,20);
	var name = GetString(SW/2-78,SH/2-10,font,10);
	var file = OpenFile(name+".sav");
	file.write("ghghghg", Level+1);
	file.flush();
	file.close();
	SwitchLevels();
}

function LoadGame(filename)
{
	var File = OpenFile(filename);
	Level = File.read("ghghghg", Level);
	StopMusic();
	File.close();
	CreateBall();
	if (!IsMapEngineRunning()) {
		if (Level < 10) MapEngine("Level_0"+Level+".rmp",GameSpeed);
		else MapEngine("Level_"+Level+".rmp",GameSpeed);
	}
	else {
		if (Level < 10) ChangeMap("Level_0"+Level+".rmp");
		else ChangeMap("Level_"+Level+".rmp");
	}
}

function LoadGameMenu()
{
	var Files = GetFileList("./save");
	var FilesLength = Files.length;
	var Arrow = new MArrow('MArrow.png',SW/2-80,(SH/2-10-(10*FilesLength))+4);
	var sel = 0;
	while (true) {
		DrawTitle();
		font.drawText(SW/2-80,(SH/2-10-(10*FilesLength))-30,"LOAD A GAME");
		window.drawWindow(SW/2-80,SH/2-10-(10*FilesLength),160,20+20*FilesLength);
		Arrow.blit();

		for (var i = 0; i < FilesLength; ++i) {
			font.drawText(SW/2-64,SH/2-10-(10*FilesLength)+i*20,Files[i]);
		}

		font.drawText(SW/2-64,SH/2-10-(10*FilesLength)+i*20,"Cancel");
		FlipScreen();
		while(AreKeysLeft()) {
			switch (GetKey()) {
				case KEY_UP:
					if(sel > 0) { sel--; Arrow.newY-=20; }
				break;
				case KEY_DOWN:
					if(sel < FilesLength) { sel++; Arrow.newY+=20; }
				break;
				case KEY_ENTER:
				case KEY_CTRL:
					if(sel < FilesLength) LoadGame(Files[sel]);
					else GameMenu();
					return;
				break;
			}
		}
	}
}

function SwitchLevels()
{
	Level++;
	IgnoredDoors = [];
	SetPersonIgnoreList(Player.name, IgnoredDoors);
	if (Level < 10) ChangeMap("Level_0"+Level+".rmp");
	else ChangeMap("Level_"+Level+".rmp");
	Player.update();
	SetFrameRate(0);
}

function NextLevel()
{
	var menu = new Menu(SW/2-80,SH/2-60,160)
	menu.appendChoice("Next Level",SwitchLevels,White,Blue);
	menu.appendChoice("Save Game",SaveNext,White,Blue);
	menu.appendChoice("Main Menu",GameMenu,White,Blue);
	menu.cancelable = false;
	menu.draw();
}

function DrawTitle()
{
	if(SpecialFX) {
		if(BG.fadev <= 0) BG.newFade = 255;
		if(BG.fadev >= 255) BG.newFade = 0;
		if(BG2.fadev <= 0) BG2.newFade = 255;
		if(BG2.fadev >= 255) BG2.newFade = 0;
		if(Title.yv <= -8) {Title.newY = 8; Title.yamt = .25}
		if(Title.yv >= 8) {Title.newY = -8; Title.yamt = .5}
		BG.blit(0,0);
	}

	BG2.blit(0,0);
	if(SpecialFX) {
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
		Twinkle.blit(Math.random()*SW, Math.random()*SH);
	}

	Overhead.blit(0, 0);
	Title.blit(SW/2-Title.img.width/2, 64);
	Radnen.blit(8, SH-Radnen.img.height-4);
}

function GameMenu()
{
	var menu = new Menu(SW/2-82,SH/2-32,164);
	menu.appendChoice("New Game", PlayGame, White, Blue);
	menu.appendChoice("Load Game", LoadGameMenu, White, Blue);
	menu.appendChoice("Custom Game", PlayGame, White, Blue);
	menu.appendChoice("Options", Options, White, Blue);
	menu.appendChoice("Credits", Credits, White, Blue);
	menu.appendChoice("Exit Game", Exit, White, Blue);
	menu.onCancel = Exit
	menu.preRender = DrawTitle;
	menu.postRender = function() {
		if (menu.CI == 0 || menu.CI == 5) {
			DrawTitle();
			FadeOut(2000);
		}
	}
	menu.draw();
}

function Credits()
{
	var MovePlane = true;
	var done = false;
	Title.newX = -SW/4-16;
	Title.xamt = 2;
	while(!IsKeyPressed(KEY_ESCAPE)) {
		DrawTitle();
		CreditPlane.blit(SW,0);
		if (MovePlane) {
			CreditPlane.newX = -CreditPlane.img.width;
			CreditPlane.xamt = 4;
			if(CreditPlane.xv <= CreditPlane.newX) MovePlane = false;
		}
		else
		{
			font.drawZoomedText(SW/2,16,2,"Credits:");
			font.drawText(SW/2,64,"Design: Radnen");
			font.drawText(SW/2,88,"Graphics: Radnen");
			font.drawText(SW/2,112,"Code: Radnen");
			font.drawText(SW/2,136,"Music: TheModArchive");
			font.drawText(SW/2,160,"Special Thanks to:");
			font.drawText(SW/2+16,184,"Spherical, and")
			font.drawText(SW/2+16,208,"My adoring fans!");
			font.drawZoomedText(SW/2,240,2,"Contact:")
			font.drawText(SW/2,304,"Andrew Helenius: Radnen");
			font.drawText(SW/2,328,"Radnen@Gmail.com");
			font.drawText(SW/2+32,SH-64,"Press ESC to Return");
		}
		FlipScreen();
	}

	Title.newX = 0;
	Title.xamt = 2;
	CreditPlane.newX = 0;
	CreditPlane.xamt = 4;
	while(!done) {
		DrawTitle();
		CreditPlane.blit(SW,0);
		if(CreditPlane.xv >= CreditPlane.newX) done = true;
		FlipScreen();
	}
	GameMenu();
}

function Options()
{
	OptionPlane.newY = -8;
	var OI = ["Music Volume","Sound Volume","Music Pitch","Game Speed","Throttle FPS","Special FX","Set Defaults","Save and Return"];
	var OL = [false, false, false, false, false, false, false];
	var Arrow = new MArrow('MArrow.png',SW/2-OptionPlane.img.width/2+32,SH/2-OptionPlane.img.height/2+84);
	var Selection = 0;
	var done = false
	while(!done) {
		DrawTitle();
		OptionPlane.blit(SW/2-CreditPlane.img.width/2,SH/2-CreditPlane.img.height/2);
		if(OptionPlane.yv >=-8) {
			if(SpecialFX) {
				if(OptionPlane.yv <= -8) {OptionPlane.newY = 8; OptionPlane.yamt = .5}
				if(OptionPlane.yv >= 8) {OptionPlane.newY = -8; OptionPlane.yamt = .5}
			}
			font.drawZoomedText(SW/2-CreditPlane.img.width/2+32,SH/2-CreditPlane.img.height/2+32,2,"Options:");
			Arrow.blit();
			for(var i = 0; i < OI.length; ++i) {
				font.drawText(SW/2-OptionPlane.img.width/2+50,SH/2-OptionPlane.img.height/2+80+i*24,OI[i]); 
			}
			if(OL[0]) OI[0] = "Music Volume  " + MusicVolume;
			else OI[0] = "Music Volume";
			if(OL[1]) OI[1] = "Sound Volume  " + SoundVolume;
			else OI[1] = "Sound Volume";
			if(OL[2]) OI[2] = "Music Pitch  " + MusicPitch;
			else OI[2] = "Music Pitch";
			if(OL[3]) OI[3] = "Game Speed  " + GameSpeed;
			else OI[3] = "Game Speed";
			if(OL[4]) OI[4] = "Throttle FPS  " + ThrottleFrameRate;
			else OI[4] = "Throttle FPS";
			if(OL[5]) OI[5] = "Special FX  " + SpecialFX;
			else OI[5] = "Special FX";
			if(OL[6]) {
				MusicVolume = 230; SoundVolume = 170;
				MusicPitch = 1; GameSpeed = 60; SetFrameRate(60);
				with(Audio) { Music.setVolume(230); Music.setPitch(1); }
				ThrottleFrameRate = true;
				SpecialFX = true; OL[6] = false;
			}
			if(OL[7]) done = true;
		}

		FlipScreen();

		while(AreKeysLeft()) {
			switch(GetKey()) {
				case KEY_UP:
					if(Selection > 0 && !OL[Selection]) {
						Selection--; Arrow.newY -= 24;
					}
					if(OL[0]) {
						if(MusicVolume < 255) MusicVolume++;
						with(Audio) Music.setVolume(MusicVolume);
					}
					if(OL[1]) {
						if(SoundVolume < 255) SoundVolume++;
					}
					if(OL[2]) {
						if(MusicPitch < 2) MusicPitch+=.25;
						with(Audio) Music.setPitch(MusicPitch);
					}
					if(OL[3]) {
						if(GameSpeed < 120) GameSpeed++;
						if(ThrottleFrameRate) SetFrameRate(GameSpeed);
					}
					if(OL[4]) {
						if(!ThrottleFrameRate) { ThrottleFrameRate = true; SetFrameRate(GameSpeed); }
						else { ThrottleFrameRate = false; SetFrameRate(0); }
					}
					if(OL[5]) {
						if(!SpecialFX) { SpecialFX = true; OptionPlane.newY = -8 }
						else {
							SpecialFX = false;
							BG2.newFade = 255; BG2.fadev = 255;
							BG.newFade = -1; BG.fadev = -1;
							OptionPlane.reset();
						}
					}
				break;
				case KEY_DOWN:
					if(Selection < OI.length - 1 && !OL[Selection]) {
						Selection++; Arrow.newY += 24;
					}
					if(OL[0]) {
						if(MusicVolume > 0) MusicVolume--;
						with(Audio) Music.setVolume(MusicVolume);
					}
					if(OL[1]) {
						if(SoundVolume > 0) SoundVolume--;
					}
					if(OL[2]) {
						if(MusicPitch > .25) MusicPitch-=.25;
						with(Audio) Music.setPitch(MusicPitch);
					}
					if(OL[3]) {
						if(GameSpeed > 40) GameSpeed--;
						if(ThrottleFrameRate) SetFrameRate(GameSpeed);
					}
					if(OL[4]) {
						if(!ThrottleFrameRate) { ThrottleFrameRate = true; SetFrameRate(GameSpeed); }
						else { ThrottleFrameRate = false; SetFrameRate(0); }
					}
					if(OL[5]) {
						if(!SpecialFX) { SpecialFX = true; OptionPlane.newY = -8; }
						else {
							SpecialFX = false;
							BG2.newFade = 255; BG2.fadev = 255;
							BG.newFade = -1; BG.fadev = -1;
							OptionPlane.reset();
						}
					}
				break;
				case KEY_ENTER:
				case KEY_CTRL:
					if(!OL[Selection]) OL[Selection] = true;
					else OL[Selection] = false;
				break;
				case KEY_ESCAPE:
					done = true;
				break;
			}
		}
	}
	SaveOptions();
	GameMenu();
}

function SaveOptions()
{
	OptionFile.write("Frames - Frame Rate",GameSpeed);
	OptionFile.write("Frames - Throttled",ThrottleFrameRate);
	OptionFile.write("Performance - Special FX",SpecialFX);
	OptionFile.write("Sounds - Music Pitch",MusicPitch);
	OptionFile.write("Sounds - Music Volume",MusicVolume);
	OptionFile.write("Sounds - Sound Volume",SoundVolume);
}

function LoadOptions()
{
	GameSpeed         = OptionFile.read("Frames - Frame Rate",GameSpeed);
	ThrottleFrameRate = OptionFile.read("Frames - Throttled",ThrottleFrameRate);
	SpecialFX         = OptionFile.read("Performance - Special FX",SpecialFX);
	MusicPitch        = OptionFile.read("Sounds - Music Pitch",MusicPitch);
	MusicVolume       = OptionFile.read("Sounds - Music Volume",MusicVolume);
	SoundVolume       = OptionFile.read("Sounds - Sound Volume",SoundVolume);
}